#include <windows.h>
#include <commctrl.h>
#include <tchar.h>
#include <stdio.h>
#include <process.h>
#include "resource.h"

HWND hTreeView = NULL;
HDC DC = NULL;
BYTE CharSet;
HINSTANCE hInst;
const TCHAR wsFontSampleWindowName[] = _TEXT("FontSample");
const int ColumNum = 16;
int Tabs[ColumNum];

struct FontDataStruct
{
	ENUMLOGFONTEX LogFontData;
	NEWTEXTMETRICEX TextMetricData;
};

struct ShowFullFontThreadStruct
{
	HFONT hFont;
	TCHAR Title[LF_FULLFACESIZE];
	HWND hwnd;
};


BOOL CALLBACK HelpDlgProc(HWND hwnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch(uMsg)
	{
		case WM_INITDIALOG:
			{
				BOOL OK = FALSE;
				HRSRC HRes = FindResource(NULL, "HELPTEXT", "BINARY");
				if (HRes)
				{
					DWORD dwSize = SizeofResource(NULL, HRes);
					if (dwSize)
					{
						HGLOBAL hGlob = LoadResource(NULL, HRes);
						if (hGlob)
						{
							const char *sHelpText = (const char *)LockResource(hGlob);
							if (sHelpText)
							{
								char *sText = new char[strlen(sHelpText)+1];
								if (sText)
								{
									memmove(sText, sHelpText, strlen(sHelpText)+1);
									sText[strlen(sHelpText)] = 0;
									OK = SetDlgItemText(hwnd, IDC_EDIT, sText);
									delete sText;
								}
							}
						}
					}
				}
				if (!OK) EndDialog(hwnd, 0);
				return 1;
			}
		case WM_COMMAND:
			{
				if (LOWORD(wParam) == IDOK)
					EndDialog(hwnd, 0);
				return 0;
			}
		case WM_CLOSE:
			{
				EndDialog(hwnd, 0);
				return 1;
			}
	}
	return 0;
}


void ShowFullFontThread (void *p)
{
	ShowFullFontThreadStruct &data = *(ShowFullFontThreadStruct *)p;
	HWND hFontDispWnd = CreateWindow(wsFontSampleWindowName, (TCHAR*)data.Title,
								WS_OVERLAPPEDWINDOW | WS_VSCROLL | WS_HSCROLL,
								CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT,
								/*data.hwnd*/NULL, NULL, hInst, (LPVOID)data.hFont);
	ShowWindow(hFontDispWnd, SW_SHOWNORMAL);
	SetForegroundWindow(hFontDispWnd);
	UpdateWindow(hFontDispWnd);
	MSG msg;
	while(GetMessage(&msg, hFontDispWnd, NULL, NULL) == TRUE)
	{
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}
	EnableWindow(GetDlgItem(data.hwnd, IDC_SHOWFONT), TRUE);
	delete p;
}


void FeedAnsiFontListbox(HWND hListWnd, const LOGFONT* lf)
{
	int iCharSizeX = 0;
	int iCharSizeY = 0;
	HFONT MyFont = CreateFontIndirect(lf);
	HDC DC = GetDC(hListWnd);
	HGDIOBJ OldFont = SelectObject(DC, MyFont);
	SIZE sz;
	for (int i = 33; i < 255; i++)
	{
		char c = i;
		BOOL b = GetTextExtentPoint32A(DC, &c, 1, &sz);
		if (sz.cx > iCharSizeX) 
			iCharSizeX = sz.cx;
		if (sz.cy > iCharSizeY) 
			iCharSizeY = sz.cy;
	}
	iCharSizeX++;
	GetTextExtentPoint32A(DC, "F0: ", 4, &sz);
	int iTabPos = sz.cx;
	GetTextExtentPoint32A(DC, "E0: ", 4, &sz);
	if (sz.cx > iTabPos) iTabPos = sz.cx;
	GetTextExtentPoint32A(DC, "D0: ", 4, &sz);
	if (sz.cx > iTabPos) iTabPos = sz.cx;
	GetTextExtentPoint32A(DC, "C0: ", 4, &sz);
	if (sz.cx > iTabPos) iTabPos = sz.cx;
	GetTextExtentPoint32A(DC, "B0: ", 4, &sz);
	if (sz.cx > iTabPos) iTabPos = sz.cx;
	GetTextExtentPoint32A(DC, "A0: ", 4, &sz);
	if (sz.cx > iTabPos) iTabPos = sz.cx;
	GetTextExtentPoint32A(DC, "90: ", 4, &sz);
	if (sz.cx > iTabPos) iTabPos = sz.cx;
	GetTextExtentPoint32A(DC, "80: ", 4, &sz);
	if (sz.cx > iTabPos) iTabPos = sz.cx;
	GetTextExtentPoint32A(DC, "70: ", 4, &sz);
	if (sz.cx > iTabPos) iTabPos = sz.cx;
	GetTextExtentPoint32A(DC, "60: ", 4, &sz);
	if (sz.cx > iTabPos) iTabPos = sz.cx;
	GetTextExtentPoint32A(DC, "50: ", 4, &sz);
	if (sz.cx > iTabPos) iTabPos = sz.cx;
	GetTextExtentPoint32A(DC, "40: ", 4, &sz);
	if (sz.cx > iTabPos) iTabPos = sz.cx;
	GetTextExtentPoint32A(DC, "30: ", 4, &sz);
	if (sz.cx > iTabPos) iTabPos = sz.cx;
	GetTextExtentPoint32A(DC, "20: ", 4, &sz);
	if (sz.cx > iTabPos) iTabPos = sz.cx;
	GetTextExtentPoint32A(DC, "10: ", 4, &sz);
	if (sz.cx > iTabPos) iTabPos = sz.cx;
	GetTextExtentPoint32A(DC, "00: ", 4, &sz);
	if (sz.cx > iTabPos) iTabPos = sz.cx;
	HFONT CourierFont = CreateFont(lf->lfHeight, 0, 0, 0, FW_NORMAL, FALSE, FALSE, FALSE, ANSI_CHARSET, OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS, DEFAULT_QUALITY, DEFAULT_PITCH, "Courier New");
	SelectObject(DC, CourierFont);
	GetTextExtentPoint32A(DC, "00: ", 4, &sz);
	if (sz.cx > iTabPos) iTabPos = sz.cx;
	SelectObject(DC, MyFont);
	DeleteObject(CourierFont);
	iTabPos++;
				
	GetTextExtentPoint32A(DC, "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz", 52, &sz);
	WORD wDialogBaseUnits = (sz.cx/26+1)/2;
	while (iCharSizeX*4%wDialogBaseUnits)
		iCharSizeX++;
	while (iTabPos*4%wDialogBaseUnits)
		iTabPos++;
	SelectObject(DC, OldFont);
	ReleaseDC(hListWnd, DC);
	OldFont = (HFONT)SendMessageA(hListWnd, WM_GETFONT, 0, 0);
	SendMessageA(hListWnd, WM_SETFONT, (WPARAM)MyFont, 0);
	if (OldFont)
		DeleteObject(OldFont);
	int iTabStops[ColumNum];
	for (i = 0; i < ColumNum; i++)
	{
		iTabStops[i] = iTabPos+i*iCharSizeX;
		Tabs[i] = iTabStops[i];
	}
	for (i = 0; i < ColumNum; i++)
		iTabStops[i] = iTabStops[i]*4/wDialogBaseUnits;
	SendMessageA(hListWnd, LB_RESETCONTENT, 0, 0);
	SendMessageA(hListWnd, LB_SETITEMHEIGHT, 0, MAKELONG(iCharSizeY, 0));
	SendMessageA(hListWnd, LB_SETTABSTOPS, ColumNum, (LPARAM)iTabStops);
	SendMessageA(hListWnd, LB_SETHORIZONTALEXTENT, iTabPos+(ColumNum)*iCharSizeX, 0);
	for (i = 32/ColumNum; i < 256/ColumNum; i++)
	{
		char s[1000]; sprintf(s, "%X:", i*ColumNum);
		char *c = s+strlen(s);
		for (int j = 0; j < ColumNum; j++)
		{
			*c++ = '\t'; *c++ = i*ColumNum+j;
			*c = 0;
		}
		j = SendMessageA(hListWnd, LB_ADDSTRING, 0, (LPARAM)s);
		SendMessageA(hListWnd, LB_SETITEMDATA, j, (LPARAM)j);
	}
}


int CALLBACK EnumFontFamExProc3(const LOGFONT *lplf, const TEXTMETRIC *lptm, DWORD FontType, LPARAM lParam)
{
	const ENUMLOGFONTEX *lpelfe = (const ENUMLOGFONTEX *)lplf;
	const NEWTEXTMETRICEX *lpntme = (const NEWTEXTMETRICEX *)lptm;
	FontDataStruct *fd = new FontDataStruct;
	fd->LogFontData	= *lpelfe;
	fd->TextMetricData = *lpntme;
	TV_INSERTSTRUCT tvInsert; ZeroMemory(&tvInsert, sizeof(tvInsert));
	tvInsert.hParent = (HTREEITEM)lParam;
	tvInsert.hInsertAfter = TVI_LAST;
	tvInsert.item.mask = TVIF_TEXT | TVIF_PARAM;
	tvInsert.item.lParam = (LPARAM)fd;
	tvInsert.item.pszText = (TCHAR *)lpelfe->elfStyle;
	tvInsert.item.cchTextMax = LF_FACESIZE;
	BOOL bInsert = TRUE;
	HTREEITEM htChilds = TreeView_GetChild(hTreeView, (HTREEITEM)lParam);
	while (htChilds)
	{
		char s[LF_FACESIZE];
		TV_ITEM tvi; ZeroMemory(&tvi, sizeof(tvi));
		tvi.mask = TVIF_TEXT | TVIF_HANDLE;
		tvi.hItem = htChilds;
		tvi.pszText = s;
		tvi.cchTextMax = sizeof(s)-1;
		TreeView_GetItem(hTreeView, &tvi);
		if (!_tcscmp(s, (TCHAR *)lpelfe->elfStyle))
			bInsert = FALSE;
		htChilds = TreeView_GetNextSibling(hTreeView, htChilds);
	}
	if (bInsert)
	TreeView_InsertItem(hTreeView, &tvInsert);
	return 1;
}

int CALLBACK EnumFontFamExProc2(const LOGFONT *lplf, const TEXTMETRIC *lptm, DWORD FontType, LPARAM lParam)
{
	const ENUMLOGFONTEX *lpelfe = (const ENUMLOGFONTEX *)lplf;
	const NEWTEXTMETRICEX *lpntme = (const NEWTEXTMETRICEX *)lptm;
	TV_INSERTSTRUCT tvInsert; ZeroMemory(&tvInsert, sizeof(tvInsert));
	tvInsert.hParent = (HTREEITEM)lParam;
	tvInsert.hInsertAfter = TVI_LAST;
	tvInsert.item.mask = TVIF_TEXT/* | TVIF_PARAM*/;
	tvInsert.item.lParam = lplf->lfCharSet;
	tvInsert.item.pszText = (TCHAR *)lpelfe->elfScript;
	tvInsert.item.cchTextMax = LF_FACESIZE;
	BOOL bInsert = TRUE;
	HTREEITEM htChilds = TreeView_GetChild(hTreeView, (HTREEITEM)lParam);
	while (htChilds)
	{
		char s[LF_FACESIZE];
		TV_ITEM tvi; ZeroMemory(&tvi, sizeof(tvi));
		tvi.mask = TVIF_TEXT | TVIF_HANDLE;
		tvi.hItem = htChilds;
		tvi.pszText = s;
		tvi.cchTextMax = sizeof(s)-1;
		TreeView_GetItem(hTreeView, &tvi);
		if (!_tcscmp(s, (TCHAR *)lpelfe->elfScript))
			bInsert = FALSE;
		htChilds = TreeView_GetNextSibling(hTreeView, htChilds);
	}
	LOGFONT lf; ZeroMemory(&lf, sizeof(lf));
lf = lpelfe->elfLogFont;
	//lf.lfCharSet = DEFAULT_CHARSET;
	//lf.lfCharSet = CharSet;
	//strcpy(lf.lfFaceName, lpelfe->elfLogFont.lfFaceName);
	if (bInsert)
		EnumFontFamiliesEx(DC, &lf, EnumFontFamExProc3, (LPARAM)TreeView_InsertItem(hTreeView, &tvInsert), 0);
	return 1;
}

int CALLBACK EnumFontFamExProc(const LOGFONT *lplf, const TEXTMETRIC *lptm, DWORD FontType, LPARAM lParam)
{
	const ENUMLOGFONTEX *lpelfe = (const ENUMLOGFONTEX *)lplf;
	const NEWTEXTMETRICEX *lpntme = (const NEWTEXTMETRICEX *)lptm;
	TV_INSERTSTRUCT tvInsert; ZeroMemory(&tvInsert, sizeof(tvInsert));
	tvInsert.hParent = (HTREEITEM)lParam;
	tvInsert.hInsertAfter = TVI_SORT;
	tvInsert.item.mask = TVIF_TEXT/* | TVIF_PARAM*/;
	tvInsert.item.pszText = (TCHAR *)lpelfe->elfLogFont.lfFaceName;
	tvInsert.item.cchTextMax = LF_FACESIZE;
	BOOL bInsert = TRUE;
	HTREEITEM htChilds = TreeView_GetRoot(hTreeView);
	while (htChilds)
	{
		char s[LF_FACESIZE];
		TV_ITEM tvi; ZeroMemory(&tvi, sizeof(tvi));
		tvi.mask = TVIF_TEXT | TVIF_HANDLE;
		tvi.hItem = htChilds;
		tvi.pszText = s;
		tvi.cchTextMax = sizeof(s)-1;
		TreeView_GetItem(hTreeView, &tvi);
		if (!_tcscmp(s, (TCHAR *)lpelfe->elfLogFont.lfFaceName))
			bInsert = FALSE;
		htChilds = TreeView_GetNextSibling(hTreeView, htChilds);
	}
	LOGFONT lf; ZeroMemory(&lf, sizeof(lf));
	lf.lfCharSet = DEFAULT_CHARSET;
	lf.lfCharSet = CharSet;
	strcpy(lf.lfFaceName, lpelfe->elfLogFont.lfFaceName);
	if (bInsert)
	EnumFontFamiliesEx(DC, &lf, EnumFontFamExProc2, (LPARAM)TreeView_InsertItem(hTreeView, &tvInsert), 0);
	return 1;
}

int CALLBACK FindNewFontFamProc(const LOGFONT *lplf, const TEXTMETRIC *lptm, DWORD FontType, LPARAM lParam)
{
	const ENUMLOGFONTEX *lpelfe = (const ENUMLOGFONTEX *)lplf;
	const NEWTEXTMETRICEX *lpntme = (const NEWTEXTMETRICEX *)lptm;
	HTREEITEM htChilds = TreeView_GetRoot(hTreeView);
	BOOL bFound = FALSE;
	while (htChilds)
	{
		char s[LF_FACESIZE];
		TV_ITEM tvi; ZeroMemory(&tvi, sizeof(tvi));
		tvi.mask = TVIF_TEXT | TVIF_HANDLE;
		tvi.hItem = htChilds;
		tvi.pszText = s;
		tvi.cchTextMax = sizeof(s)-1;
		TreeView_GetItem(hTreeView, &tvi);
		if (!_tcscmp(s, (TCHAR *)lpelfe->elfLogFont.lfFaceName))
			bFound = TRUE;
		htChilds = TreeView_GetNextSibling(hTreeView, htChilds);
	}
	if (!bFound)
		_tcscpy((TCHAR *)lParam, (TCHAR *)lpelfe->elfLogFont.lfFaceName); 
	return 1;
}

BOOL CALLBACK DialogProc(HWND hwnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	static FontDataStruct *fdCurSel;
	static int iFontSize;
	static BOOL bDontUpdateFontSample;
	static char sLoadedFontName[1000];
	switch(uMsg)
	{
		case WM_INITDIALOG:
		{
			*sLoadedFontName = 0;
			bDontUpdateFontSample = FALSE;
			hTreeView = GetDlgItem(hwnd, IDC_TREE);
			CharSet = 255;
			iFontSize = 0;
			fdCurSel = NULL;
			HWND hCHarSetWnd = GetDlgItem(hwnd, IDC_CHARSET);
			int i = SendMessage(hCHarSetWnd, CB_ADDSTRING, 0, (LPARAM)_TEXT("Ansi"));
			SendMessage(hCHarSetWnd, CB_SETITEMDATA, i, ANSI_CHARSET);
			i = SendMessage(hCHarSetWnd, CB_ADDSTRING, 0, (LPARAM)_TEXT("Symbol"));
			SendMessage(hCHarSetWnd, CB_SETITEMDATA, i, SYMBOL_CHARSET);
			i = SendMessage(hCHarSetWnd, CB_ADDSTRING, 0, (LPARAM)_TEXT("Shift-JIS"));
			SendMessage(hCHarSetWnd, CB_SETITEMDATA, i, SHIFTJIS_CHARSET);
			i = SendMessage(hCHarSetWnd, CB_ADDSTRING, 0, (LPARAM)_TEXT("Hangeul"));
			SendMessage(hCHarSetWnd, CB_SETITEMDATA, i, HANGEUL_CHARSET);
			i = SendMessage(hCHarSetWnd, CB_ADDSTRING, 0, (LPARAM)_TEXT("GB2312"));
			SendMessage(hCHarSetWnd, CB_SETITEMDATA, i, GB2312_CHARSET);
			i = SendMessage(hCHarSetWnd, CB_ADDSTRING, 0, (LPARAM)_TEXT("Chinese Big 5"));
			SendMessage(hCHarSetWnd, CB_SETITEMDATA, i, CHINESEBIG5_CHARSET);
			i = SendMessage(hCHarSetWnd, CB_ADDSTRING, 0, (LPARAM)_TEXT("OEM"));
			SendMessage(hCHarSetWnd, CB_SETITEMDATA, i, OEM_CHARSET);
			i = SendMessage(hCHarSetWnd, CB_ADDSTRING, 0, (LPARAM)_TEXT("Johab"));
			SendMessage(hCHarSetWnd, CB_SETITEMDATA, i, JOHAB_CHARSET);
			i = SendMessage(hCHarSetWnd, CB_ADDSTRING, 0, (LPARAM)_TEXT("Hebrew"));
			SendMessage(hCHarSetWnd, CB_SETITEMDATA, i, HEBREW_CHARSET);
			i = SendMessage(hCHarSetWnd, CB_ADDSTRING, 0, (LPARAM)_TEXT("Arabic"));
			SendMessage(hCHarSetWnd, CB_SETITEMDATA, i, ARABIC_CHARSET);
			i = SendMessage(hCHarSetWnd, CB_ADDSTRING, 0, (LPARAM)_TEXT("Greek"));
			SendMessage(hCHarSetWnd, CB_SETITEMDATA, i, GREEK_CHARSET);
			i = SendMessage(hCHarSetWnd, CB_ADDSTRING, 0, (LPARAM)_TEXT("Turkish"));
			SendMessage(hCHarSetWnd, CB_SETITEMDATA, i, TURKISH_CHARSET);
			i = SendMessage(hCHarSetWnd, CB_ADDSTRING, 0, (LPARAM)_TEXT("Thai"));
			SendMessage(hCHarSetWnd, CB_SETITEMDATA, i, THAI_CHARSET);
			i = SendMessage(hCHarSetWnd, CB_ADDSTRING, 0, (LPARAM)_TEXT("East Europe"));
			SendMessage(hCHarSetWnd, CB_SETITEMDATA, i, EASTEUROPE_CHARSET);
			i = SendMessage(hCHarSetWnd, CB_ADDSTRING, 0, (LPARAM)_TEXT("Russian"));
			SendMessage(hCHarSetWnd, CB_SETITEMDATA, i, RUSSIAN_CHARSET);
			i = SendMessage(hCHarSetWnd, CB_ADDSTRING, 0, (LPARAM)_TEXT("Mac"));
			SendMessage(hCHarSetWnd, CB_SETITEMDATA, i, MAC_CHARSET);
			i = SendMessage(hCHarSetWnd, CB_ADDSTRING, 0, (LPARAM)_TEXT("Baltic"));
			SendMessage(hCHarSetWnd, CB_SETITEMDATA, i, BALTIC_CHARSET);
			i = SendMessage(hCHarSetWnd, CB_ADDSTRING, 0, (LPARAM)_TEXT("All"));
			SendMessage(hCHarSetWnd, CB_SETITEMDATA, i, DEFAULT_CHARSET);
			SendMessage(hCHarSetWnd, CB_SETCURSEL, i, 0);
			SendDlgItemMessage(hwnd, IDC_SETTEXT, BM_SETCHECK, (WPARAM)BST_UNCHECKED, 0);
			SendDlgItemMessage(hwnd, IDC_TEXTOUT, BM_SETCHECK, (WPARAM)BST_CHECKED, 0);
			BOOL bNewTextOut = (BST_CHECKED == SendDlgItemMessage(hwnd, IDC_TEXTOUT, BM_GETCHECK, 0, 0));
			ShowWindow(GetDlgItem(hwnd, IDC_FONTLISTSETTEXT), (bNewTextOut)?SW_HIDE:SW_SHOW);
			ShowWindow(GetDlgItem(hwnd, IDC_FONTLISTTEXTOUT), (bNewTextOut)?SW_SHOW:SW_HIDE);

			SendDlgItemMessage(hwnd, IDC_FONTLISTTEXTOUT, WM_SETFONT, (WPARAM)CreateFont(12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0), 0);
			SendDlgItemMessage(hwnd, IDC_FONTLISTSETTEXT, WM_SETFONT, (WPARAM)CreateFont(12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0), 0);
			SendMessage(hwnd, WM_COMMAND, MAKELONG(IDC_CHARSET, CBN_SELENDOK), (LPARAM)hCHarSetWnd);
			HFONT OldFont = (HFONT)SendDlgItemMessage(hwnd, IDC_SAMPLEEDIT, WM_GETFONT, 0, 0);
			LOGFONT(lf);
			GetObject(OldFont, sizeof(lf), &lf);
			SendDlgItemMessage(hwnd, IDC_SAMPLEEDIT, WM_SETFONT, (WPARAM)CreateFontIndirect(&lf), NULL);
			SendDlgItemMessage(hwnd, IDC_BUDDY, UDM_SETRANGE, 0, MAKELPARAM(100, -100));
			return 1;
		}
		case WM_DRAWITEM:
		{
			if (wParam != IDC_FONTLISTTEXTOUT) return 0;
			DRAWITEMSTRUCT &dis = *(DRAWITEMSTRUCT *)lParam;

			LOGFONT lf;
			GetObject(GetCurrentObject(dis.hDC, OBJ_FONT), sizeof(LOGFONT), &lf);
			HFONT CourierFont = CreateFont(lf.lfHeight, 0, 0, 0, FW_NORMAL, FALSE, FALSE, FALSE, ANSI_CHARSET, OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS, DEFAULT_QUALITY, DEFAULT_PITCH, "Courier New");

			char s[1000]; *s = 0;
			char *c = s;
			int i = dis.itemData+32/ColumNum;

			for (int j = 0; j < ColumNum; j++)
			{
				*c++ = '\t'; *c++ = i*ColumNum+j;
				*c = 0;
			}
			TabbedTextOutA(dis.hDC, dis.rcItem.left, dis.rcItem.top, s, strlen(s), ColumNum, Tabs, 0);

			sprintf(s, "%X:", i*ColumNum);

			HFONT OldFont = (HFONT)SelectObject(dis.hDC, CourierFont);
			TextOutA(dis.hDC, dis.rcItem.left, dis.rcItem.top, s, strlen(s));
			SelectObject(dis.hDC, OldFont);

			if (CourierFont) DeleteObject(CourierFont);
			return TRUE;
		}
		case WM_NOTIFY:
		{
			if (wParam == IDC_TREE)
			{
				NM_TREEVIEW &nmTreeView = *(NM_TREEVIEW *)lParam;
				switch(nmTreeView.hdr.code)
				{
					case TVN_DELETEITEM:
					{
						FontDataStruct *fds = (FontDataStruct *) nmTreeView.itemOld.lParam;
						if (fds) delete fds;
						return 0;
					}
					case TVN_SELCHANGED:
					{
						HTREEITEM htItem = nmTreeView.itemNew.hItem;
						HTREEITEM htChild = htItem;
						while(htChild = TreeView_GetChild(hTreeView, htChild))
						{
							htItem = htChild;
						}
						TV_ITEM tvItem; ZeroMemory(&tvItem, sizeof(tvItem));
						tvItem.mask = TVIF_PARAM | TVIF_HANDLE;
						tvItem.hItem = htItem;
						int i = TreeView_GetItem(hTreeView, &tvItem);
						fdCurSel = ((FontDataStruct *)tvItem.lParam);
						SetDlgItemText(hwnd, IDC_FULLNAME, NULL);
						if (!fdCurSel || bDontUpdateFontSample) 
							return 0;
						TCHAR t[1000];
						_tcscpy(t, (TCHAR *)fdCurSel->LogFontData.elfFullName);
						_tcscat(t, _TEXT(" ("));
						_tcscat(t, (TCHAR *)fdCurSel->LogFontData.elfScript);
						_tcscat(t, _TEXT(", "));
						_tcscat(t, (TCHAR *)fdCurSel->LogFontData.elfStyle);
						_tcscat(t, _TEXT(")"));
						SetDlgItemText(hwnd, IDC_FULLNAME, (TCHAR*)t);
						iFontSize = abs(fdCurSel->LogFontData.elfLogFont.lfHeight);
						itoa(iFontSize, t, 10);
						SetDlgItemText(hwnd, IDC_FONTSIZE, t);
						FeedAnsiFontListbox(GetDlgItem(hwnd, IDC_FONTLISTSETTEXT), &fdCurSel->LogFontData.elfLogFont);
						FeedAnsiFontListbox(GetDlgItem(hwnd, IDC_FONTLISTTEXTOUT), &fdCurSel->LogFontData.elfLogFont);
						HFONT MyFont = CreateFontIndirect(&fdCurSel->LogFontData.elfLogFont);
						HFONT OldFont = (HFONT)SendDlgItemMessage(hwnd, IDC_SAMPLEEDIT, WM_GETFONT, 0, 0);
						SendDlgItemMessage(hwnd, IDC_SAMPLEEDIT, WM_SETFONT, (WPARAM)MyFont, MAKELONG(TRUE, 0));
						DeleteObject(OldFont);
						return 1;
					}
				}
			}
			return 0;
		}
		case WM_CLOSE:
		{
			EndDialog(hwnd, 0);
			return 0;
		}
		case WM_COMMAND:
		{
			switch (LOWORD(wParam))
			{
				case IDC_SETTEXT:
				case IDC_TEXTOUT:
				{
					BOOL bNewTextOut = (BST_CHECKED == SendDlgItemMessage(hwnd, IDC_TEXTOUT, BM_GETCHECK, 0, 0));
					int i = SendDlgItemMessage(hwnd, (bNewTextOut)?IDC_FONTLISTSETTEXT:IDC_FONTLISTTEXTOUT, LB_GETTOPINDEX, 0, 0);
					SendDlgItemMessage(hwnd, (!bNewTextOut)?IDC_FONTLISTSETTEXT:IDC_FONTLISTTEXTOUT, LB_SETTOPINDEX, i, 0);
					ShowWindow(GetDlgItem(hwnd, IDC_FONTLISTSETTEXT), (bNewTextOut)?SW_HIDE:SW_SHOW);
					ShowWindow(GetDlgItem(hwnd, IDC_FONTLISTTEXTOUT), (bNewTextOut)?SW_SHOW:SW_HIDE);
					return 1;
				}
				case IDC_SHOWFONT:
				{
					if (!fdCurSel) return 0;
					EnableWindow(GetDlgItem(hwnd, IDC_SHOWFONT), FALSE);
					ShowFullFontThreadStruct *ThreadData = new ShowFullFontThreadStruct;
					TCHAR t[10];
					GetWindowText((HWND)lParam, t, sizeof(t)/sizeof(TCHAR));
					int iNewFontSize = atoi(t);
					LOGFONT lf; lf = fdCurSel->LogFontData.elfLogFont;
					if (iFontSize)
					{
						lf.lfHeight = iFontSize;
						lf.lfWidth = 0;
						FeedAnsiFontListbox(GetDlgItem(hwnd, IDC_FONTLISTTEXTOUT), &lf);
						FeedAnsiFontListbox(GetDlgItem(hwnd, IDC_FONTLISTSETTEXT), &lf);
						HFONT MyFont = CreateFontIndirect(&lf);
						HFONT OldFont = (HFONT)SendDlgItemMessage(hwnd, IDC_SAMPLEEDIT, WM_GETFONT, 0, 0);
						SendDlgItemMessage(hwnd, IDC_SAMPLEEDIT, WM_SETFONT, (WPARAM)MyFont, MAKELONG(TRUE, 0));
						DeleteObject(OldFont);
					}
					ThreadData->hFont = CreateFontIndirect(&lf);
					ThreadData->hwnd = hwnd;
					_tcscpy(ThreadData->Title, (TCHAR *)fdCurSel->LogFontData.elfFullName);
					_beginthread(ShowFullFontThread, 0, (void *)ThreadData);
					return 0;
				}
				case IDOK:
				{
					EndDialog(hwnd, 0);
					return 0;
				}
				case IDC_MYHELP:
				{
					DialogBox(hInst, "HELP", hwnd, HelpDlgProc);
					return 0;
				}
				case IDC_FONTSIZE:
				{
					if (HIWORD(wParam) == EN_CHANGE)
					{
						TCHAR t[10];
						GetWindowText((HWND)lParam, t, sizeof(t)/sizeof(TCHAR));
						int iNewFontSize = atoi(t);
						if (fdCurSel && iNewFontSize && (iNewFontSize != iFontSize))
						{
							LOGFONT lf; lf = fdCurSel->LogFontData.elfLogFont;
							lf.lfHeight = iNewFontSize;
							lf.lfWidth = 0;
							iFontSize  = iNewFontSize;
							FeedAnsiFontListbox(GetDlgItem(hwnd, IDC_FONTLISTSETTEXT), &lf);
							FeedAnsiFontListbox(GetDlgItem(hwnd, IDC_FONTLISTTEXTOUT), &lf);
							HFONT MyFont = CreateFontIndirect(&lf);
							HFONT OldFont = (HFONT)SendDlgItemMessage(hwnd, IDC_SAMPLEEDIT, WM_GETFONT, 0, 0);
							SendDlgItemMessage(hwnd, IDC_SAMPLEEDIT, WM_SETFONT, (WPARAM)MyFont, MAKELONG(TRUE, 0));
							DeleteObject(OldFont);
						}
					}
					return 0;
				}
				case IDC_FONTFILE:
				{
					if (strlen(sLoadedFontName))
						RemoveFontResource(sLoadedFontName);
					*sLoadedFontName = 0;

					OPENFILENAME of; ZeroMemory(&of, sizeof(of));
					of.lStructSize = sizeof(of);
					of.hwndOwner = hwnd;
					of.lpstrFilter = "FontFiles\0*.FON;*.FNT;*.TTF;*.FOT\0All Files\0*\0";
					of.nFilterIndex = 1;
					of.lpstrFile = sLoadedFontName;
					of.nMaxFile = sizeof(sLoadedFontName)-1;
					of.lpstrTitle = "Select Font";
					of.Flags = OFN_EXPLORER | OFN_FILEMUSTEXIST | OFN_HIDEREADONLY;
					if (GetOpenFileName(&of))
					{
						if (AddFontResource(sLoadedFontName))
						{
							TCHAR tcsFaceName[LF_FACESIZE]; *tcsFaceName = 0;
							LOGFONT lf; ZeroMemory(&lf, sizeof(lf));
							lf.lfCharSet = DEFAULT_CHARSET;
							lf.lfCharSet = CharSet;
							DC = GetDC(NULL);
							EnumFontFamiliesEx(DC, &lf, FindNewFontFamProc, (LPARAM)tcsFaceName, 0);
							ReleaseDC(NULL, DC);
							CharSet = 255;
							SendMessage(hwnd, WM_COMMAND, MAKELONG(IDC_CHARSET, CBN_SELENDOK), (LPARAM)GetDlgItem(hwnd, IDC_CHARSET));
							if (*tcsFaceName)
							{
								HTREEITEM htChilds = TreeView_GetRoot(hTreeView);
								while (htChilds)
								{
									char s[LF_FACESIZE];
									TV_ITEM tvi; ZeroMemory(&tvi, sizeof(tvi));
									tvi.mask = TVIF_TEXT | TVIF_HANDLE;
									tvi.hItem = htChilds;
									tvi.pszText = s;
									tvi.cchTextMax = sizeof(s)-1;
									TreeView_GetItem(hTreeView, &tvi);
									if (!_tcscmp(s, tcsFaceName))
									{
										TreeView_Select(hTreeView, tvi.hItem, TVGN_CARET);
										SetFocus(hTreeView);
									}
									htChilds = TreeView_GetNextSibling(hTreeView, htChilds);
									}
							}
						}
						else
							*sLoadedFontName = 0;
					}
					return 0;
				}
				case IDC_CHARSET:
				{
					if (HIWORD(wParam) == CBN_SELENDOK)
					{
						int i = SendMessage((HWND)lParam, CB_GETCURSEL, 0, 0);
						if (i != CB_ERR)
						{
							int j  = (BYTE)SendMessage((HWND)lParam, CB_GETITEMDATA, i, 0);
							if (j != CharSet)
							{
								fdCurSel = NULL;
								SendDlgItemMessage(hwnd, IDC_FONTLISTSETTEXT, LB_RESETCONTENT, 0, 0);
								SendDlgItemMessage(hwnd, IDC_FONTLISTTEXTOUT, LB_RESETCONTENT, 0, 0);
								EnableWindow(GetDlgItem(hwnd, IDC_SHOWFONT), FALSE);
								CharSet = j;
								bDontUpdateFontSample = TRUE;
								int k = TreeView_DeleteAllItems(hTreeView);
								bDontUpdateFontSample = FALSE;
								fdCurSel = NULL;
								DC = GetDC(NULL);
								LOGFONT lf; ZeroMemory(&lf, sizeof(lf));
								lf.lfCharSet = DEFAULT_CHARSET;
								lf.lfCharSet = CharSet;
								EnumFontFamiliesEx(DC, &lf, EnumFontFamExProc, (LPARAM)TVI_ROOT, 0);
								if (TreeView_GetCount(hTreeView))
									EnableWindow(GetDlgItem(hwnd, IDC_SHOWFONT), TRUE);
								ReleaseDC(NULL, DC);
							}
						}
					}
					return 0;
				}
			}
			return 0;
		}
		case WM_DESTROY:
		{
			if (strlen(sLoadedFontName))
				RemoveFontResource(sLoadedFontName);
			*sLoadedFontName = 0;
		}
	}
	return 0;
} 



BOOL CALLBACK WaitDialogProc(HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	return 0;
}


LRESULT CALLBACK FontSampleWindowProc(HWND hwnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	const int CharsPerRow = 16;
	static HFONT MyFont = NULL, CourierFont = NULL;
	static int iLineDist, iCharSizeX, iScreenSizeX, iScreenSizeY, iScrollPosX, iScrollPosY;
	static int iTabPos, iLineNumY;

	switch (uMsg)
	{
		case WM_CREATE:
			{
				HWND hWaitDialog = NULL;
				
				CREATESTRUCT &cs = *(CREATESTRUCT *)lParam;
				MyFont = (HFONT)cs.lpCreateParams;
				LOGFONT lf;
				GetObject(MyFont, sizeof(LOGFONT), &lf);
				if (abs(lf.lfHeight) < 12)
				{
					DeleteObject(MyFont);
					lf.lfHeight = 12;
					MyFont = CreateFontIndirect(&lf);
				}
				CourierFont = CreateFont(lf.lfHeight, 0, 0, 0, FW_NORMAL, FALSE, FALSE, FALSE, ANSI_CHARSET, OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS, DEFAULT_QUALITY, DEFAULT_PITCH, "Courier New");
				HDC DC = GetDC(hwnd);
				HGDIOBJ OldFont = SelectObject(DC, MyFont);
				SIZE sz;
				iLineDist = iCharSizeX = 0;
				int iFrom = 0;
				int iTo = 0x10000;
				if (!_tcsicmp(lf.lfFaceName, _TEXT("Symbol")))
				{
					iFrom = 32;
					iTo = 255;
				}
				for (int i = iFrom; i < iTo; i++)
				{
					wchar_t w = i;
					if(GetTextExtentPoint32W(DC, &w, 1, &sz))
					{
						if (sz.cx > iCharSizeX) 
							iCharSizeX = sz.cx;
						if (sz.cy > iLineDist) 
							iLineDist = sz.cy;
					}
					DWORD d = GetLastError();
					d++;
				}
				SelectObject(DC, CourierFont);
				GetTextExtentPoint32W(DC, L"FFFF: ", 6, &sz);
				iTabPos = sz.cx;
				SelectObject(DC, OldFont);
				ReleaseDC(hwnd, DC);
				iScreenSizeX = iTabPos+CharsPerRow*iCharSizeX;
				iLineNumY = 0x10000/CharsPerRow;
				iScreenSizeY = iLineNumY*iLineDist;
				iScrollPosX = 0;
				iScrollPosY = 0;
				DestroyWindow(hWaitDialog);
				return 0;
			}
		case WM_PAINT:
			{
				PAINTSTRUCT ps;
				HDC DC = BeginPaint(hwnd, &ps);
				HGDIOBJ OldFont = SelectObject(DC, MyFont);
				for (int i = 0; i < 0x10000/CharsPerRow; i++)
				{
					int y = (i-iScrollPosY)*iLineDist;
					if ((y+iLineDist >= ps.rcPaint.top) 
						&& (y < ps.rcPaint.bottom))
					{
						wchar_t s[10];
						_itow(i*CharsPerRow, s, 16);
						wchar_t *w = s;
						while (*w)
						{
							if(*w > L'A') 
								*w -= L'a'-L'A';
							w++;
						}
						while (w-s < 4)
						{
							memmove(s+1, s, 4*sizeof(wchar_t));
							*s = L'0';
							w++;
						}
						wcscpy(w, L":");
						SelectObject(DC, CourierFont);
						TextOutW(DC, -iScrollPosX, y, s, wcslen(s));
						SelectObject(DC, MyFont);
						for (int j = 0; j < CharsPerRow; j++)
						{
							wchar_t ch = CharsPerRow*i+j;
							if (!ch) ch = 32;
							TextOutW(DC, iTabPos+j*iCharSizeX-iScrollPosX, y, &ch, 1);
						}
					}
				}
				SelectObject(DC, OldFont);
				EndPaint(hwnd, &ps);
				return 0;
			}
		case WM_KEYDOWN:
			{
				switch(wParam)
				{
					case VK_UP:
						SendMessage(hwnd, WM_VSCROLL, MAKELONG(SB_LINEUP, iScrollPosY-1), NULL); break;
					case VK_DOWN:
						SendMessage(hwnd, WM_VSCROLL, MAKELONG(SB_LINEDOWN, iScrollPosY+1), NULL); break;
					case VK_PRIOR:
						SendMessage(hwnd, WM_VSCROLL, MAKELONG(SB_PAGEUP, iScrollPosY), NULL); break;
					case VK_NEXT:
						SendMessage(hwnd, WM_VSCROLL, MAKELONG(SB_PAGEDOWN, iScrollPosY), NULL); break;
					case VK_HOME:
						SendMessage(hwnd, WM_VSCROLL, MAKELONG(SB_TOP, 0), NULL); break;
					case VK_END:
						SendMessage(hwnd, WM_VSCROLL, MAKELONG(SB_BOTTOM, iScrollPosY), NULL); break;
					case VK_LEFT:
						SendMessage(hwnd, WM_HSCROLL, MAKELONG(SB_LINEUP, iScrollPosX-1), NULL); break;
					case VK_RIGHT:
						SendMessage(hwnd, WM_HSCROLL, MAKELONG(SB_LINEDOWN, iScrollPosX+1), NULL); break;
					default: return DefWindowProc(hwnd, uMsg, wParam, lParam);
				}
				return 0;
			}
		case WM_SIZE:
			{
				int iSizeX = (int)LOWORD(lParam);
				int iSizeY = (int)HIWORD(lParam);
				SCROLLINFO si; ZeroMemory(&si, sizeof(si)); si.cbSize = sizeof(si);
				si.fMask = SIF_PAGE | SIF_RANGE;
				si.nMin = 0;
				si.nPage = iSizeX;
				si.nMax = iScreenSizeX;
				SetScrollInfo(hwnd, SB_HORZ, &si, TRUE);
				si.nPage = iSizeY/iLineDist;
				si.nMax = iLineNumY-1;
				if (!si.nPage) si.nPage = 1;
				SetScrollInfo(hwnd, SB_VERT, &si, TRUE);
				si.fMask = SIF_POS;
				GetScrollInfo(hwnd, SB_HORZ, &si);
				iScrollPosX = si.nPos;
				GetScrollInfo(hwnd, SB_VERT, &si);
				iScrollPosY = si.nPos;
				return 0;
			}
		case WM_VSCROLL:
			{
				SCROLLINFO si; ZeroMemory(&si, sizeof(si)); si.cbSize = sizeof(si);
				si.fMask = SIF_ALL;
				GetScrollInfo(hwnd, SB_VERT, &si);
				int iScrollInc = 0;
				switch (LOWORD(wParam))
				{
					case SB_TOP: iScrollInc = -iScrollPosY; break;
					case SB_BOTTOM: iScrollInc = si.nMax-iScrollPosY; break;
					case SB_LINEUP: iScrollInc = -1; break;
					case SB_LINEDOWN: iScrollInc = 1; break;
					case SB_PAGEUP: iScrollInc = -(int)si.nPage; break;
					case SB_PAGEDOWN: iScrollInc = si.nPage; break;
					case SB_THUMBPOSITION:
					case SB_THUMBTRACK: iScrollInc = (int)HIWORD(wParam)-iScrollPosY; break;
				}
				if (iScrollInc > si.nMax-iScrollPosY-(int)si.nPage+1)
					iScrollInc = si.nMax-iScrollPosY-si.nPage+1;
				if (iScrollInc < -iScrollPosY) iScrollInc = -iScrollPosY;
				if (iScrollInc)
				{
					iScrollPosY += iScrollInc;
					si.nPos = iScrollPosY;
					si.fMask = SIF_POS;
					SetScrollInfo(hwnd, SB_VERT, &si, TRUE);
					ScrollWindow(hwnd, 0, -iScrollInc*iLineDist, NULL, NULL);
					UpdateWindow(hwnd);
				}
				return 0;
			}
		case WM_HSCROLL:
			{
				SCROLLINFO si; ZeroMemory(&si, sizeof(si)); si.cbSize = sizeof(si);
				si.fMask = SIF_ALL;
				GetScrollInfo(hwnd, SB_HORZ, &si);
				int iScrollInc = 0;
				switch (LOWORD(wParam))
				{
					case SB_TOP: iScrollInc = -iScrollPosX; break;
					case SB_BOTTOM: iScrollInc = si.nMax-iScrollPosX; break;
					case SB_LINEUP: iScrollInc = -1; break;
					case SB_LINEDOWN: iScrollInc = 1; break;
					case SB_PAGEUP: iScrollInc = -(int)si.nPage; break;
					case SB_PAGEDOWN: iScrollInc = si.nPage; break;
					case SB_THUMBPOSITION:
					case SB_THUMBTRACK: iScrollInc = (int)HIWORD(wParam)-iScrollPosX; break;
				}
				if (iScrollInc > (int)si.nMax-iScrollPosX-(int)si.nPage+1) 
					iScrollInc = si.nMax-iScrollPosX-si.nPage+1;
				if (iScrollInc < -iScrollPosX) iScrollInc = -iScrollPosX;
				if (iScrollInc)
				{
					iScrollPosX += iScrollInc;
					si.nPos = iScrollPosX;
					si.fMask = SIF_POS;
					SetScrollInfo(hwnd, SB_HORZ, &si, TRUE);
					ScrollWindow(hwnd, -iScrollInc, 0, NULL, NULL);
					UpdateWindow(hwnd);
				}
				return 0;
			}
		case WM_DESTROY:
			{
				if (MyFont)
					DeleteObject(MyFont);
				MyFont = NULL;
				if (CourierFont)
					DeleteObject(CourierFont);
				MyFont = CourierFont;
				return 0;
			}
		default: return DefWindowProc(hwnd, uMsg, wParam, lParam);
	}
	return 0;
}


int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpszCmdLine, int nCmdShow)
{
	InitCommonControls();
	hInst = hInstance;
	WNDCLASS wcl; ZeroMemory(&wcl, sizeof(wcl));
	wcl.style = CS_HREDRAW| CS_VREDRAW;
	wcl.lpfnWndProc = FontSampleWindowProc;
	wcl.hInstance = hInst;
	wcl.lpszClassName = wsFontSampleWindowName;
	wcl.hbrBackground = (HBRUSH) GetStockObject(WHITE_BRUSH);
	if (!RegisterClass(&wcl))
		return 0;
	DialogBox(hInstance, "DIALOG", NULL, DialogProc);
	return 0;
}
  
